﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;

public enum SGImeError
{
    UNKNOWN = 0,
    SERVICE_NOT_CONNECTED = 1
}

//for commit code. -1 to commit string, other to commit key
public enum SGImeKey
{
    KEYCODE_COMMIT = -1,
    KEYCODE_UNKNOWN = 0,
    KEYCODE_ENTER = 66,
    KEYCODE_DEL = 67,
    KEYCODE_VOICE_START = 1000,
    KEYCODE_VOICE_END = 1001,
}

public enum SGImeInputType
{
    TYPE_CLASS_TEXT = 1,
    TYPE_CLASS_NUMBER = 2,
    TYPE_CLASS_PHONE = 3,
    TYPE_CLASS_DATETIME = 4,
    TYPE_CLASS_MUTE_TEXT = 5,
}

public enum SGImeTextType
{
    TYPE_TEXT_VARIATION_NORMAL = 0,
    TYPE_TEXT_VARIATION_URI = 0x10,
    TYPE_TEXT_VARIATION_EMAIL_ADDRESS  = 0x20,
    TYPE_TEXT_VARIATION_EMAIL_SUBJECT = 0x30,
    TYPE_TEXT_VARIATION_SHORT_MESSAGE = 0x40,
    TYPE_TEXT_VARIATION_LONG_MESSAGE = 0x50,
    TYPE_TEXT_VARIATION_PERSON_NAME = 0x60,
    TYPE_TEXT_VARIATION_POSTAL_ADDRESS = 0x70,
    TYPE_TEXT_VARIATION_PASSWORD = 0x80,
    TYPE_TEXT_VARIATION_VISIBLE_PASSWORD = 0x90,
    TYPE_TEXT_VARIATION_WEB_EDIT_TEXT = 0xa0,
    TYPE_TEXT_VARIATION_FILTER = 0xb0,
    TYPE_TEXT_VARIATION_PHONETIC = 0xc0,
    TYPE_TEXT_VARIATION_WEB_EMAIL_ADDRESS = 0xd0,
    TYPE_TEXT_VARIATION_WEB_PASSWORD = 0xe0
}

public enum SGImeMotionEventType
{
    ACTION_DOWN,
    ACTION_UP,
    ACTION_MOVE,
    ACTION_CANCEL,
    ACTION_OUTSIDE,
    ACTION_POINTER_DOWN,
    ACTION_POINTER_UP,
    ACTION_HOVER_MOVE,
    ACTION_SCROLL,
    ACTION_HOVER_ENTER,
    ACTION_HOVER_EXIT,
    ACTION_BUTTON_PRESS,
    ACTION_BUTTON_RELEASE,
    ACTION_LONGPRESS = 100
}
